import React from 'react';
import { useQuery } from '@tanstack/react-query';
import { api } from '../services/api';
import { Users, Plus } from 'lucide-react';

export default function Tables() {
  const { data: tables } = useQuery({
    queryKey: ['tables'],
    queryFn: async () => {
      const response = await api.get('/tables');
      return response.data.data;
    }
  });

  const getStatusColor = (status: string) => {
    switch (status) {
      case 'AVAILABLE':
        return 'bg-green-100 text-green-800';
      case 'OCCUPIED':
        return 'bg-red-100 text-red-800';
      case 'RESERVED':
        return 'bg-yellow-100 text-yellow-800';
      case 'MAINTENANCE':
        return 'bg-gray-100 text-gray-800';
      default:
        return 'bg-gray-100 text-gray-800';
    }
  };

  const getStatusText = (status: string) => {
    switch (status) {
      case 'AVAILABLE':
        return 'Boş';
      case 'OCCUPIED':
        return 'Dolu';
      case 'RESERVED':
        return 'Rezerve';
      case 'MAINTENANCE':
        return 'Bakım';
      default:
        return status;
    }
  };

  return (
    <div className="space-y-6">
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-2xl font-bold text-gray-900">Masalar</h1>
          <p className="text-gray-600">Masa durumlarını takip edin</p>
        </div>
        <button className="btn-primary flex items-center space-x-2">
          <Plus size={20} />
          <span>Yeni Masa</span>
        </button>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
        {tables?.map((table: any) => (
          <div key={table.id} className="card-hover">
            <div className="flex items-center justify-between mb-4">
              <div className="w-12 h-12 bg-primary-100 rounded-lg flex items-center justify-center">
                <Users size={24} className="text-primary-600" />
              </div>
              <span className={`px-2 py-1 rounded-full text-xs ${getStatusColor(table.status)}`}>
                {getStatusText(table.status)}
              </span>
            </div>
            <h3 className="text-lg font-semibold text-gray-900 mb-2">Masa {table.number}</h3>
            <p className="text-gray-600 text-sm mb-4">{table.capacity} kişilik</p>
            <div className="flex items-center justify-between">
              <span className="text-sm text-gray-500">Kapasite: {table.capacity}</span>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
} 