import { Router } from 'express';
import { PrismaClient } from '@prisma/client';
import { z } from 'zod';

const router = Router();
const prisma = new PrismaClient();

// Get inventory items
router.get('/', async (req, res) => {
  try {
    const items = await prisma.inventoryItem.findMany({
      include: {
        product: true
      },
      orderBy: { product: { name: 'asc' } }
    });

    res.json({
      success: true,
      data: items
    });
  } catch (error) {
    res.status(500).json({ message: 'Server error' });
  }
});

// Update inventory
router.patch('/:id', async (req, res) => {
  try {
    const { id } = req.params;
    const { quantity, cost } = req.body;

    const item = await prisma.inventoryItem.update({
      where: { id },
      data: { quantity, cost },
      include: { product: true }
    });

    res.json({
      success: true,
      data: item
    });
  } catch (error) {
    res.status(500).json({ message: 'Server error' });
  }
});

export default router; 