# Espiropos Restaurant Management System

Modern restoran yönetim sistemi - Simpra benzeri kapsamlı çözüm

## Özellikler

### 🍽️ Restoran Yönetimi
- **POS Sistemi**: Hızlı sipariş alma ve ödeme
- **Menü Yönetimi**: Kategori bazlı menü düzenleme
- **QR Menü**: Müşteriler için dijital menü
- **Masa Yönetimi**: Rezervasyon ve masa takibi

### 📊 Raporlama & Analiz
- **Günlük/Haftalık/Aylık Ciro**: Detaylı gelir analizi
- **Gelir/Gider Takibi**: Finansal yönetim
- **Stok Takibi**: Otomatik stok kontrolü
- **Depo Sayımı**: Periyodik envanter kontrolü

### 🛒 Stok & Envanter
- **Stok Yönetimi**: Ürün giriş/çıkış takibi
- **Tedarikçi Yönetimi**: Tedarikçi bilgileri
- **Otomatik Uyarılar**: Düşük stok bildirimleri
- **Maliyet Hesaplama**: Ürün maliyet analizi

### 👥 Müşteri Yönetimi
- **Sadakat Programı**: Müşteri puanlama
- **Rezervasyon Sistemi**: Online rezervasyon
- **Müşteri Geçmişi**: Sipariş geçmişi

## Teknolojiler

### Frontend
- React 18 + TypeScript
- Tailwind CSS
- React Router
- React Query
- Chart.js (Grafikler)

### Backend
- Node.js + Express
- TypeScript
- PostgreSQL
- Prisma ORM
- JWT Authentication

### Özellikler
- Responsive Design
- Real-time Updates
- Offline Support
- Multi-language Support

## Kurulum

```bash
# Tüm bağımlılıkları yükle
npm run install-all

# Geliştirme modunda başlat
npm run dev
```

## Kullanım

1. **Backend**: http://localhost:5000
2. **Frontend**: http://localhost:3000
3. **Admin Panel**: http://localhost:3000/admin

## Lisans

MIT License 